/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

import jp.mosp.common.dto.CmAspUserDto;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.human.dao.MKihonDao;
import jp.mosp.payroll.base.PayrollDao;
import jp.mosp.payroll.dto.PaymentListDto;

/**
 * ^f[^ꗗ擾@\񋟂B<br><br>
 * {@link PaymentListDto}pāADBJavavOԂŃR[hLB<br>
 */
public class PaymentListDao extends PayrollDao {
	
	// e[uyуL[
	private static final String TABLE_1 = PhPaymentDao.TABLE;
	private static final String TABLE_2 = MKihonDao   .TABLE;

	// 
	public static final String COL_KCODE_1       = TABLE_1 + "." + PhPaymentDao.COL_KCODE        ;	// ЈR[h
	public static final String COL_KCODE_2       = TABLE_2 + "." + MKihonDao   .COL_KCODE        ;	// ЈR[h
	public static final String COL_CALC_MONTH    = PhPaymentDao.COL_CALC_MONTH   ;	// vZN
	public static final String COL_PAYMENT_TOTAL = PhPaymentDao.COL_PAYMENT_TOTAL;	// xz
	public static final String COL_SIMEI         = MKihonDao   .COL_SIMEI        ;	// 
	public static final String COL_FURIGANA      = MKihonDao   .COL_FURIGANA     ;	// ӂ肪
	public static final String COL_JCODE         = MKihonDao   .COL_JCODE        ;	// ƏR[h
	public static final String COL_SCODE         = MKihonDao   .COL_SCODE        ;	// R[h
	public static final String COL_YCODE         = MKihonDao   .COL_YCODE        ;	// ER[h
	
	/**
	 * {@link PayrollDao#PayrollDao(Properties, String, CmAspUserDto, CmUserDto, Connection)}
	 * sB<br>
	 * @param cfg     ݒt@C
	 * @param cmd     R}h
	 * @param aspUser ASP[U[
	 * @param user    [U[
	 * @param conn    DBRlNV
	 */
	public PaymentListDao(
			Properties   cfg,
			String       cmd,
			CmAspUserDto aspUser,
			CmUserDto    user,
			Connection   conn
	) {
		super(cfg, cmd, aspUser, user, conn);
		INSERT_DATE = "";
		INSERT_USER = "";
		UPDATE_DATE = "";
		UPDATE_USER = "";
	}
	
	/**
	 * ʂDTOƂĎ擾B<br>
	 * @return R[h(DTO)
	 * @throws SQLException
	 */
	private PaymentListDto mapping() throws SQLException {
		PaymentListDto dto = new PaymentListDto();
		dto.setKCode       (rs.getString(PhPaymentDao.COL_KCODE));	// ЈR[h
		dto.setSimei       (rs.getString(COL_SIMEI        ));	// 
		dto.setFurigana    (rs.getString(COL_FURIGANA     ));	// ӂ肪
		dto.setJCode       (rs.getString(COL_JCODE        ));	// ƏR[h
		dto.setSCode       (rs.getString(COL_SCODE        ));	// R[h
		dto.setYCode       (rs.getString(COL_YCODE        ));	// ER[h
		dto.setPaymentTotal(rs.getInt   (COL_PAYMENT_TOTAL));	// xz
		return dto;
	}
	
	/**
	 * ʂDTOListƂĎ擾B<br>
	 * @return ʃXg
	 * @throws SQLException
	 */
	protected List<PaymentListDto> mappingAll() throws SQLException {
		List<PaymentListDto> all = new ArrayList<PaymentListDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}
	
	/**
	 * ɂf[^擾B<br>
	 * @param kCode        ЈR[h
	 * @param officeCode   ƏR[h
	 * @param sectionCode  R[h
	 * @param calcMonth    vZN
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PaymentListDto> findForPaymentData(
			String  kCode      ,
			String  officeCode ,
			String  sectionCode,
			Date    calcMonth   
	) throws SQLException, IllegalAccessException {
		try {
			index = 1;
			prepareStatement(getSelectStatement(getClass()) +
					getConditionForPaymentList(officeCode, sectionCode, ""));
			setDateParam(index++, calcMonth);
			setParam(index++, kCode + "%");
			setParam(index++, "%%");
			if (officeCode != null && !officeCode.equals("")) {
				setParam(index++, officeCode);
			}
			if (sectionCode != null && !sectionCode.equals("")) {
				setParam(index++, sectionCode);
			}
			// s
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂf[^擾B<br>
	 * @param kCode        ЈR[h
	 * @param kKana        tKi
	 * @param officeCode   ƏR[h
	 * @param sectionCode  R[h
	 * @param positionCode EʃR[h
	 * @param calcMonth    vZN
	 * @param sortKey      \[gL[
	 * @param isAscending  tO
	 * @param limit        ~bg
	 * @param offset       ItZbg
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<PaymentListDto> findForPaymentList(
			String  kCode       ,
			String  kKana       ,
			String  officeCode  ,
			String  sectionCode ,
			String  positionCode,
			Date    calcMonth   ,
			String  sortKey     ,
			boolean isAscending ,
			int     limit       ,
			int     offset
	) throws SQLException, IllegalAccessException {
		try {
			index = 1;
			prepareStatement(
					getSelectStatement(getClass()) +
					getConditionForPaymentList(officeCode, sectionCode, positionCode) +
					getPageStatement(sortKey, isAscending)
			);
			setDateParam(index++, calcMonth);
			setParam(index++, kCode + "%");
			setParam(index++, "%" + kKana + "%");
			if (officeCode != null && !officeCode.equals("")) {
				setParam(index++, officeCode);
			}
			if (sectionCode != null && !sectionCode.equals("")) {
				setParam(index++, sectionCode);
			}
			if (positionCode != null && !positionCode.equals("")) {
				setParam(index++, positionCode);
			}
			setParam(index++, limit );
			setParam(index++, offset);
			// s
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ɂ蓾f[^̌擾B<br>
	 * @param kCode        ЈR[h
	 * @param kKana        tKi
	 * @param officeCode   ƏR[h
	 * @param sectionCode  R[h
	 * @param positionCode EʃR[h
	 * @param calcMonth    vZN
	 * @return int 
	 * @throws SQLException
	 */
	public int countForPaymentList(
			String kCode       ,
			String kKana       ,
			String officeCode  ,
			String sectionCode ,
			String positionCode,
			Date    calcMonth  
	) throws SQLException {
		try {
			index = 1;
			prepareStatement(
					getSelectCountStatement() + 
					getConditionForPaymentList(officeCode, sectionCode, positionCode)
			);
			setDateParam(index++, calcMonth);
			setParam(index++, kCode + "%");
			setParam(index++, "%" + kKana + "%");
			if (officeCode != null && !officeCode.equals("")) {
				setParam(index++, officeCode);
			}
			if (sectionCode != null && !sectionCode.equals("")) {
				setParam(index++, sectionCode);
			}
			if (positionCode != null && !positionCode.equals("")) {
				setParam(index++, positionCode);
			}
			executeQuery();
			int count = 0;
			if (rs.next()) {
				count = rs.getInt(1);
			}
			return count;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
	/**
	 * ^vZpSQL擾B
	 * @param officeCode   ƏR[h
	 * @param sectionCode  R[h
	 * @param positionCode EʃR[h
	 * @return	^vZpSQL 
	 */
	private static String getConditionForPaymentList(
			String officeCode  ,
			String sectionCode ,
			String positionCode
	) {
		StringBuffer sb = new StringBuffer();
		sb.append("FROM ");
		sb.append(TABLE_1 + ", " + TABLE_2 + " ");
		sb.append("WHERE ");
		sb.append(COL_KCODE_1 + " = " + COL_KCODE_2 + " ");
		sb.append(" AND ");
		sb.append(COL_CALC_MONTH + " = ? ");
		sb.append(" AND ");
		sb.append(COL_KCODE_1 + " LIKE ? ");
		sb.append(" AND ");
		sb.append(COL_FURIGANA + " LIKE ? ");
		if (officeCode != null && !officeCode.equals("")) {
			sb.append("AND ");
			sb.append(COL_JCODE + " =  ? ");
		}
		if (sectionCode != null && !sectionCode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_SCODE + " =  ? ");
		}
		if (positionCode != null && !positionCode.equals("")) {
			sb.append(" AND ");
			sb.append(COL_YCODE + " = ? ");
		}
		return sb.toString();
	}
	
	
	/**
	 * ɂf[^擾B<br>
	 * @param kCode        ЈR[h
	 * @param officeCode   ƏR[h
	 * @param sectionCode  R[h
	 * @param calcMonth    vZN
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 */
	public List<PaymentListDto> findForPayment(
			Date    calcMonth   
	) throws SQLException, IllegalAccessException {
		try {
			StringBuffer sb = new StringBuffer();
			index = 1;
			sb.append(getSelectStatement(getClass()));
			sb.append("FROM ");
			sb.append(TABLE_1 + ", " + TABLE_2 + " ");
			sb.append("WHERE ");
			sb.append(COL_KCODE_1 + " = " + COL_KCODE_2 + " ");
			sb.append(" AND ");
			sb.append(COL_CALC_MONTH + " = ? ");
			prepareStatement(sb.toString());
			setParam(index++, calcMonth);
			// s
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
}
